/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.List;
import java.util.Set;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRPotions;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemSword;
import lotr.common.item.LOTRMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class LOTRItemBattleaxe
extends LOTRItemSword {
    private float efficiencyOnProperMaterial;

    public LOTRItemBattleaxe(LOTRMaterial material) {
        this(material.toToolMaterial());
    }

    public LOTRItemBattleaxe(Item.ToolMaterial material) {
        super(material);
        this.efficiencyOnProperMaterial = material.func_77998_b();
        this.setHarvestLevel("axe", material.func_77996_d());
        this.lotrWeaponDamage += 2.0f;
    }

    public float func_150893_a(ItemStack itemstack, Block block) {
        float f = super.func_150893_a(itemstack, block);
        if (f == 1.0f && block != null && (block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151582_l)) {
            return this.efficiencyOnProperMaterial;
        }
        if (block == Blocks.field_150440_ba || block == Blocks.field_150423_aK) {
            return 10.0f;
        }
        return f;
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int i, int j, int k, EntityLivingBase entity) {
        if ((double)block.func_149712_f(world, i, j, k) != 0.0) {
            itemstack.func_77972_a(1, entity);
        }
        return true;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.none;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        World world = attacker.field_70170_p;
        if (!world.field_72995_K && world.field_73012_v.nextFloat() <= 0.1f && !target.func_70644_a(LOTRPotions.vulnerability)) {
            EnumDifficulty difficulty = world.field_73013_u;
            int baseDuration = 1 + difficulty.func_151525_a() * 2;
            int duration = (baseDuration + world.field_73012_v.nextInt(baseDuration)) * 60;
            world.func_72956_a((Entity)target, "lotr:misc.bone", 1.0f, 1.0f);
            target.func_70690_d(new PotionEffect(LOTRPotions.vulnerability.field_76415_H, duration));
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (player != null) {
            String factionName;
            int reputation;
            LOTRPlayerData playerData = LOTRLevelData.getData(player);
            LOTRFaction pledgeFaction = playerData.getPledgeFaction();
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_DWARF) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else if (reputation >= 10000 && reputation < 15000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 15000}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"2.0"}));
                } else if (reputation >= 15000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.dwarfDamage.active", (Object[])new Object[]{"2.0"}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TREE) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else if (reputation >= 10000 && reputation < 15000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                } else if (reputation >= 20000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TROLL) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                list.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                if (reputation < 20000) {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                } else {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.trollDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_ORC) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_MAN) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 5000) {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 5000}));
                } else {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.manDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
        }
    }

    private LOTRFaction.FactionType getPriorityFactionType(Set<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ELF)) {
            return LOTRFaction.FactionType.TYPE_ELF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TREE)) {
            return LOTRFaction.FactionType.TYPE_TREE;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_MAN)) {
            return LOTRFaction.FactionType.TYPE_MAN;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ORC)) {
            return LOTRFaction.FactionType.TYPE_ORC;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TROLL)) {
            return LOTRFaction.FactionType.TYPE_TROLL;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }
}

